/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SimpleDir {
    public static List<File> getAllFolders(File file) throws IOException {
        File[] folders;
        if (!file.exists()) {
            throw new IOException("File does not exist:" + file);
        }
        ArrayList<File> output = new ArrayList<File>();
        for (File f : folders = SimpleDir.listDir(file)) {
            output.add(f);
        }
        return output;
    }

    public static File[] listFile(File dir) {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory();
            }
        };
        return dir.listFiles(fileFilter);
    }

    public static File[] listDir(File dir) {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        return dir.listFiles(fileFilter);
    }

    public static List<File> getAllFiles(List<File> file) throws IOException {
        if (file.size() == 0) {
            return new ArrayList<File>(0);
        }
        if (file.size() == 1) {
            return SimpleDir.getAllFiles(file.get(0));
        }
        ArrayList<File> out = new ArrayList<File>();
        for (File f : file) {
            out.addAll(SimpleDir.getAllFiles(f));
        }
        return out;
    }

    public static List<File> getAllFiles(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File does not exist:" + file);
        }
        File[] files = SimpleDir.listFile(file);
        File[] folders = SimpleDir.listDir(file);
        ArrayList<File> out = new ArrayList<File>();
        for (File f : files) {
            out.add(f);
        }
        for (File f : folders) {
            out.addAll(SimpleDir.getAllFiles(f));
        }
        return out;
    }
}

