/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.factories;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jzy3d.bridge.IFrame;
import org.jzy3d.bridge.awt.FrameAWT;
import org.jzy3d.bridge.swing.FrameSwing;
import org.jzy3d.chart.AWTChart;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.keyboard.camera.ICameraKeyController;
import org.jzy3d.chart.controllers.keyboard.camera.NewtCameraKeyController;
import org.jzy3d.chart.controllers.keyboard.screenshot.IScreenshotKeyController;
import org.jzy3d.chart.controllers.keyboard.screenshot.NewtScreenshotKeyController;
import org.jzy3d.chart.controllers.mouse.camera.ICameraMouseController;
import org.jzy3d.chart.controllers.mouse.camera.NewtCameraMouseController;
import org.jzy3d.chart.controllers.mouse.picking.IMousePickingController;
import org.jzy3d.chart.controllers.mouse.picking.NewtMousePickingController;
import org.jzy3d.chart.factories.ChartComponentFactory;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Dimension;
import org.jzy3d.maths.Rectangle;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.rendering.canvas.CanvasNewtAwt;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.OffscreenCanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.AWTRenderer3d;
import org.jzy3d.plot3d.rendering.view.AWTView;
import org.jzy3d.plot3d.rendering.view.Renderer3d;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.layout.ColorbarViewportLayout;
import org.jzy3d.plot3d.rendering.view.layout.IViewportLayout;

public class NewtChartComponentFactory
extends ChartComponentFactory {
    static Logger logger = Logger.getLogger(NewtChartComponentFactory.class);

    public static Chart chart() {
        return NewtChartComponentFactory.chart(Quality.Intermediate);
    }

    public static Chart chart(Quality quality) {
        NewtChartComponentFactory f = new NewtChartComponentFactory();
        return f.newChart(quality, IChartComponentFactory.Toolkit.newt);
    }

    public static Chart chart(String toolkit) {
        NewtChartComponentFactory f = new NewtChartComponentFactory();
        return f.newChart(Chart.DEFAULT_QUALITY, toolkit);
    }

    public static Chart chart(Quality quality, IChartComponentFactory.Toolkit toolkit) {
        NewtChartComponentFactory f = new NewtChartComponentFactory();
        return f.newChart(quality, toolkit);
    }

    public static Chart chart(Quality quality, String toolkit) {
        NewtChartComponentFactory f = new NewtChartComponentFactory();
        return f.newChart(quality, toolkit);
    }

    @Override
    public Chart newChart(IChartComponentFactory factory, Quality quality, String toolkit) {
        return new AWTChart(factory, quality, toolkit);
    }

    @Override
    public IAxe newAxe(BoundingBox3d box, View view) {
        AxeBox axe = new AxeBox(box);
        axe.setView(view);
        return axe;
    }

    @Override
    public IViewportLayout newViewportLayout() {
        return new ColorbarViewportLayout();
    }

    @Override
    public View newView(Scene scene, ICanvas canvas, Quality quality) {
        return new AWTView(this.getFactory(), scene, canvas, quality);
    }

    @Override
    public Renderer3d newRenderer(View view, boolean traceGL, boolean debugGL) {
        return new AWTRenderer3d(view, traceGL, debugGL);
    }

    @Override
    protected IFrame newFrameSwing(Chart chart, Rectangle bounds, String title) {
        return new FrameSwing(chart, bounds, title);
    }

    @Override
    protected IFrame newFrameAWT(Chart chart, Rectangle bounds, String title, String message) {
        return new FrameAWT(chart, bounds, title, message);
    }

    @Override
    public ICanvas newCanvas(IChartComponentFactory factory, Scene scene, Quality quality, String windowingToolkit, GLCapabilities capabilities) {
        boolean traceGL = false;
        boolean debugGL = false;
        IChartComponentFactory.Toolkit chartType = this.getToolkit(windowingToolkit);
        switch (chartType) {
            case awt: {
                return new CanvasNewtAwt(factory, scene, quality, (GLCapabilitiesImmutable)capabilities, traceGL, debugGL);
            }
            case swing: {
                return new CanvasNewtAwt(factory, scene, quality, (GLCapabilitiesImmutable)capabilities, traceGL, debugGL);
            }
            case newt: {
                return new CanvasNewtAwt(factory, scene, quality, (GLCapabilitiesImmutable)capabilities, traceGL, debugGL);
            }
            case offscreen: {
                Dimension dimension = this.getCanvasDimension(windowingToolkit);
                return new OffscreenCanvas(factory, scene, quality, capabilities, dimension.width, dimension.height, traceGL, debugGL);
            }
        }
        throw new IllegalArgumentException("unknown chart type:" + (Object)((Object)chartType));
    }

    @Override
    protected ICanvas newCanvasAWT(IChartComponentFactory chartComponentFactory, Scene scene, Quality quality, GLCapabilities capabilities, boolean traceGL, boolean debugGL) {
        throw new IllegalArgumentException("Can't ask for an AWT chart type in Newt Factory.");
    }

    @Override
    protected ICanvas newCanvasSwing(IChartComponentFactory chartComponentFactory, Scene scene, Quality quality, GLCapabilities capabilities, boolean traceGL, boolean debugGL) {
        throw new IllegalArgumentException("Can't ask for an Swing chart type in Newt Factory.");
    }

    @Override
    public IChartComponentFactory getFactory() {
        return this;
    }

    public JFrame newFrame(JPanel panel) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame frame = new JFrame();
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }

    @Override
    public ICameraMouseController newMouseCameraController(Chart chart) {
        return new NewtCameraMouseController(chart);
    }

    @Override
    public IMousePickingController newMousePickingController(Chart chart, int clickWidth) {
        return new NewtMousePickingController(chart, clickWidth);
    }

    @Override
    public ICameraKeyController newKeyboardCameraController(Chart chart) {
        return new NewtCameraKeyController(chart);
    }

    @Override
    public IScreenshotKeyController newKeyboardScreenshotController(Chart chart) {
        String file = SCREENSHOT_FOLDER + "capture-" + Utils.dat2str(new Date(), "yyyy-MM-dd-HH-mm-ss") + ".png";
        NewtScreenshotKeyController screenshot = new NewtScreenshotKeyController(chart, file);
        screenshot.addListener(new IScreenshotKeyController.IScreenshotEventListener(){

            @Override
            public void failedScreenshot(String file, Exception e) {
                logger.error((Object)("Failed to save screenshot to '" + file + "'"), (Throwable)e);
            }

            @Override
            public void doneScreenshot(String file) {
                logger.info((Object)("Screenshot: " + file));
            }
        });
        return screenshot;
    }

    @Override
    public IFrame newFrame(Chart chart, Rectangle bounds, String title) {
        return this.newFrameAWT(chart, bounds, title, null);
    }
}

