/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart;

import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.mouse.camera.ICameraMouseController;
import org.jzy3d.maths.Rectangle;

public class ChartLauncher {
    static Logger logger = Logger.getLogger(ChartLauncher.class);
    public static String SCREENSHOT_FOLDER = "./data/screenshots/";

    public static ICameraMouseController openChart(Chart chart) {
        return ChartLauncher.openChart(chart, new Rectangle(0, 0, 800, 600), "Jzy3d", true);
    }

    public static ICameraMouseController openChart(Chart chart, Rectangle rectangle) {
        return ChartLauncher.openChart(chart, rectangle, "Jzy3d", true);
    }

    public static ICameraMouseController openChart(Chart chart, String title) {
        return ChartLauncher.openChart(chart, new Rectangle(0, 0, 800, 600), title, true);
    }

    public static ICameraMouseController openChart(Chart chart, Rectangle bounds, String title) {
        return ChartLauncher.openChart(chart, bounds, title, true);
    }

    public static ICameraMouseController openChart(Chart chart, Rectangle bounds, String title, boolean allowSlaveThreadOnDoubleClick) {
        return ChartLauncher.openChart(chart, bounds, title, allowSlaveThreadOnDoubleClick, false);
    }

    public static ICameraMouseController openChart(Chart chart, Rectangle bounds, String title, boolean allowSlaveThreadOnDoubleClick, boolean startThreadImmediatly) {
        ICameraMouseController mouse = ChartLauncher.configureControllers(chart, title, allowSlaveThreadOnDoubleClick, startThreadImmediatly);
        chart.render();
        ChartLauncher.frame(chart, bounds, title);
        return mouse;
    }

    public static ICameraMouseController configureControllers(Chart chart, String title, boolean allowSlaveThreadOnDoubleClick, boolean startThreadImmediatly) {
        chart.addKeyboardCameraController();
        chart.addKeyboardScreenshotController();
        return chart.addMouseCameraController();
    }

    public static void openStaticChart(Chart chart) {
        ChartLauncher.openStaticChart(chart, new Rectangle(0, 0, 800, 600), "Jzy3d");
    }

    public static void openStaticChart(Chart chart, Rectangle bounds, String title) {
        chart.render();
        ChartLauncher.frame(chart, bounds, title);
    }

    public static void instructions() {
        System.out.println(ChartLauncher.makeInstruction());
        System.out.println("------------------------------------");
    }

    public static String makeInstruction() {
        StringBuffer sb = new StringBuffer();
        sb.append("Rotate     : Left click and drag mouse\n");
        sb.append("Scale      : Roll mouse wheel\n");
        sb.append("Z Shift    : Right click and drag mouse\n");
        sb.append("Animate    : Double left click\n");
        sb.append("Screenshot : Press 's'\n");
        return sb.toString();
    }

    public static void frame(Chart chart, Rectangle bounds, String title) {
        chart.getFactory().newFrame(chart, bounds, title);
    }

    public static void screenshot(Chart chart, String filename) throws IOException {
        TextureData screen;
        File output = new File(filename);
        if (!output.getParentFile().exists()) {
            output.mkdirs();
        }
        if ((screen = chart.screenshot()) != null) {
            TextureIO.write((TextureData)screen, (File)new File(filename));
            logger.info((Object)("Dumped screenshot in: " + filename));
        } else {
            logger.error((Object)"screenshot not available");
        }
    }
}

